## 目录
- [1. 特征工程有哪些？](#1-特征工程有哪些)
  - [1.1 特征归一化](#11-特征归一化)
  - [1.2 类别型特征](#12-类别型特征)
  - [1.3 高维组合特征的处理](#13-高维组合特征的处理)
  - [1.4 文本表示模型](#14-文本表示模型)
  - [1.5 其它特征工程](#15-其它特征工程)
  - [1.6 特征工程脑图](#16-特征工程脑图)
- [2. 机器学习优化方法](#2-机器学习优化方法)
  - [2.1 机器学习常用损失函数](#21-机器学习常用损失函数)
  - [2.2 什么是凸优化](#22-什么是凸优化)
  - [2.3 正则化项](#23-正则化项)
  - [2.4 常见的几种最优化方法](#24-常见的几种最优化方法)
  - [2.5 降维方法](#25-降维方法)
- [3. 机器学习评估方法](#3-机器学习评估方法)
  - [3.1 准确率(Accuracy)](#31-准确率accuracy)
  - [3.2 精确率（Precision）](#32-精确率precision)
  - [3.3 召回率(Recall)](#33-召回率recall)
  - [3.4 F1值(H-mean值)](#34-f1值h-mean值)
  - [3.4 ROC曲线](#34-roc曲线)
  - [3.5 余弦距离和欧式距离](#35-余弦距离和欧式距离)
  - [3.6 A/B测试](#36-ab测试)
  - [3.7 模型评估方法](#37-模型评估方法)
  - [3.8 超参数调优](#38-超参数调优)
  - [3.9 过拟合和欠拟合](#39-过拟合和欠拟合)
- [4. 检验方法](#4-检验方法)
  - [4.1 KS检验](#41-ks检验)
  - [4.2 T检验](#42-t检验)
  - [4.3 F检验](#43-f检验)
  - [4.4 Grubbs检验](#44-grubbs检验)
  - [4.5 卡方检验](#45-卡方检验)
- [5. 参考文献](#4-参考文献)

## 1. 特征工程有哪些？

特征工程，顾名思义，是对原始数据进行一系列工程处理，将其提炼为特征，作为输入供算法和模型使用。从本质上来讲，特征工程是一个表示和展现数 据的过程。在实际工作中，**特征工程旨在去除原始数据中的杂质和冗余**，设计更高效的特征以刻画求解的问题与预测模型之间的关系。

主要讨论以下两种常用的数据类型。

1. 结构化数据。结构化数据类型可以看作关系型数据库的一张表，每列都 有清晰的定义，包含了数值型、类别型两种基本类型；每一行数据表示一个样本 的信息。
2. 非结构化数据。非结构化数据主要包括文本、图像、音频、视频数据， 其包含的信息无法用一个简单的数值表示，也没有清晰的类别定义，并且每条数 据的大小各不相同。

### 1.1 特征归一化

为了消除数据特征之间的量纲影响，我们需要对特征进行归一化处理，使得 不同指标之间具有可比性。例如，分析一个人的身高和体重对健康的影响，如果 使用米（m）和千克（kg）作为单位，那么身高特征会在1.6～1.8m的数值范围 内，体重特征会在50～100kg的范围内，分析出来的结果显然会倾向于数值差别比 较大的体重特征。想要得到更为准确的结果，就需要进行特征归一化 （Normalization）处理，使各指标处于同一数值量级，以便进行分析。

对数值类型的特征做归一化可以将所有的特征都统一到一个大致相同的数值 区间内。最常用的方法主要有以下两种。

1. **线性函数归一化**（Min-Max Scaling）。它对原始数据进行线性变换，使 结果映射到[0, 1]的范围，实现对原始数据的等比缩放。归一化公式如下，其中*X*为原始数据， ![](https://latex.codecogs.com/gif.latex?X_{max}、X_{min})分别为数据最大值和最小值。 

   ![](https://latex.codecogs.com/gif.latex?X_{norm}=\frac{X-X_{min}}{X_{max}-X_{min}})

2. **零均值归一化**（Z-Score Normalization）。它会将原始数据映射到均值为 0、标准差为1的分布上。具体来说，假设原始特征的均值为μ、标准差为σ，那么 归一化公式定义为

   ![](https://latex.codecogs.com/gif.latex?z=\frac{x-u}{\sigma})

优点：**训练数据归一化后，容易更快地通过梯度下降找 到最优解。**

![](http://wx4.sinaimg.cn/mw690/00630Defly1g5cdl44ubjj30gz08i40j.jpg)

当然，数据归一化并不是万能的。在实际应用中，通过梯度下降法求解的模 型通常是需要归一化的，包括线性回归、逻辑回归、支持向量机、神经网络等模 型。但对于决策树模型则并不适用。

### 1.2 类别型特征

类别型特征（Categorical Feature）主要是指性别（男、女）、血型（A、B、 AB、O）等只在有限选项内取值的特征。类别型特征原始输入通常是字符串形 式，除了决策树等少数模型能直接处理字符串形式的输入，对于逻辑回归、支持 向量机等模型来说，类别型特征必须经过处理转换成数值型特征才能正确工作。

1. **序号编码**

   序号编码通常用于处理类别间具有大小关系的数据。例如成绩，可以分为 低、中、高三档，并且存在“高>中>低”的排序关系。序号编码会按照大小关系对 类别型特征赋予一个数值ID，例如高表示为3、中表示为2、低表示为1，转换后依 然保留了大小关系。

2. **独热编码(one-hot)**

   独热编码通常用于处理类别间不具有大小关系的特征。例如血型，一共有4个 取值（A型血、B型血、AB型血、O型血），独热编码会把血型变成一个4维稀疏 向量，A型血表示为（1, 0, 0, 0），B型血表示为（0, 1, 0, 0），AB型表示为（0, 0, 1, 0），O型血表示为（0, 0, 0, 1）。对于类别取值较多的情况下使用独热编码。

3. **二进制编码 **

   二进制编码主要分为两步，先用序号编码给每个类别赋予一个类别ID，然后 将类别ID对应的二进制编码作为结果。以A、B、AB、O血型为例，下图是二进制编码的过程。A型血的ID为1，二进制表示为001；B型血的ID为2，二进制表示为 010；以此类推可以得到AB型血和O型血的二进制表示。

   ![](http://wx1.sinaimg.cn/mw690/00630Defly1g5cdqz4zruj30lf07d74g.jpg)

### 1.3 高维组合特征的处理 

为了提高复杂关系的拟合能力，在特征工程中经常会把一阶离散特征两两组 合，构成高阶组合特征。以广告点击预估问题为例，原始数据有语言和类型两种 离散特征，第一张图是语言和类型对点击的影响。为了提高拟合能力，语言和类型可 以组成二阶特征，第二张图是语言和类型的组合特征对点击的影响。

![](http://wx3.sinaimg.cn/mw690/00630Defly1g5cdvbua1aj30n30kf752.jpg)

### 1.4 文本表示模型 

文本是一类非常重要的非结构化数据，如何表示文本数据一直是机器学习领 域的一个重要研究方向。

1. **词袋模型和N-gram模型**

   最基础的文本表示模型是词袋模型。顾名思义，就是将每篇文章看成一袋子 词，并忽略每个词出现的顺序。具体地说，就是将整段文本以词为单位切分开， 然后每篇文章可以表示成一个长向量，向量中的每一维代表一个单词，而该维对 应的权重则反映了这个词在原文章中的重要程度。常用TF-IDF来计算权重。

2. **主题模型**

   主题模型用于从文本库中发现有代表性的主题（得到每个主题上面词的分布 特性），并且能够计算出每篇文章的主题分布。

3. **词嵌入与深度学习模型**

   词嵌入是一类将词向量化的模型的统称，核心思想是将每个词都映射成低维 空间（通常K=50～300维）上的一个稠密向量（Dense Vector）。K维空间的每一 维也可以看作一个隐含的主题，只不过不像主题模型中的主题那样直观。

### 1.5 其它特征工程

1. 如果某个特征当中有**缺失值**，缺失比较少的话，可以使用该特征的平均值或者其它比较靠谱的数据进行填充；缺失比较多的话可以考虑删除该特征。
2. 可以分析特征与结果的相关性，把相关性小的特征去掉。

### 1.6 特征工程脑图

![](https://julyedu-img-public.oss-cn-beijing.aliyuncs.com/Public/Image/Question/1512980743_407.png)

## 2. 机器学习优化方法

优化是应用数学的一个分支，也是机器学习的核心组成部分。实际上，机器 学习算法 = 模型表征 + 模型评估 + 优化算法。其中，优化算法所做的事情就是在 模型表征空间中找到模型评估指标最好的模型。不同的优化算法对应的模型表征 和评估指标不尽相同。

### 2.1 机器学习常用损失函数

损失函数（loss function）是用来估量你模型的预测值f(x)与真实值Y的不一致程度，它是一个非负实值函数,通常使用L(Y, f(x))来表示，损失函数越小，模型的鲁棒性就越好。常见的损失函数如下：

1. **平方损失函数**

   ![](http://wx1.sinaimg.cn/mw690/00630Defly1g5e5tzcgisj30aa01hwed.jpg)

   Y-f(X)表示的是残差，整个式子表示的是残差的平方和，而我们的目的就是最小化这个目标函数值（注：该式子未加入正则项），也就是最小化残差的平方和。而在实际应用中，通常会使用均方差（MSE）作为一项衡量指标，公式如下：

   ![](https://latex.codecogs.com/gif.latex?MSE=\frac{1}{n}\sum_{i=1}^{n}(Y_i^{'}-Y_i)^2)

   该损失函数一般使用在线性回归当中。

2. **log损失函数**

   ![](https://wx1.sinaimg.cn/large/00630Defly1g4pvtz3tw9j30et04v0sw.jpg)
   
   公式中的 y=1 表示的是真实值为1时用第一个公式，真实 y=0 用第二个公式计算损失。为什么要加上log函数呢？可以试想一下，当真实样本为1是，但h=0概率，那么log0=∞，这就对模型最大的惩罚力度；当h=1时，那么log1=0，相当于没有惩罚，也就是没有损失，达到最优结果。所以数学家就想出了用log函数来表示损失函数。
   
   最后按照梯度下降法一样，求解极小值点，得到想要的模型效果。该损失函数一般使用在逻辑回归中。
   
   ![](http://wx2.sinaimg.cn/mw690/00630Defly1g5cf7z1k1rj30b40b4wej.jpg)
   
3. **Hinge损失函数**

   ![](https://latex.codecogs.com/gif.latex?L_i=\sum_{j\neq t_i}max(0,f(x_i,W)_j-(f(x_i,W)_{y_i}-\bigtriangleup)))

   SVM采用的就是Hinge Loss，用于“最大间隔(max-margin)”分类。

   ![](http://wx1.sinaimg.cn/mw690/00630Defly1g4w5ezjr64j30se03pmy6.jpg)

   详细见之前[SVM的文章1.2.3](https://github.com/NLP-LOVE/ML-NLP/tree/master/Machine%20Learning/4.%20SVM)

### 2.2 什么是凸优化

**凸函数**的严格定义为，函数L(·) 是凸函数当且仅当对定义域中的任意两点x，y和任意实数λ∈[0,1]总有：

![](http://wx4.sinaimg.cn/mw690/00630Defly1g5e5wisdtuj30d401ijra.jpg)

该不等式的一个直观解释是，凸函数曲面上任意两点连接而成的线段，其上的任 意一点都不会处于该函数曲面的下方，如下图所示所示。

![](http://wx4.sinaimg.cn/mw690/00630Defly1g5cfpms6woj30e1049wez.jpg)

凸优化问题的例子包括支持向量机、线性回归等 线性模型，非凸优化问题的例子包括低秩模型（如矩阵分解）、深度神经网络模型等。

### 2.3 正则化项

使用正则化项，也就是给loss function加上一个参数项，正则化项有**L1正则化、L2正则化、ElasticNet**。加入这个正则化项好处：

- 控制参数幅度，不让模型“无法无天”。
- 限制参数搜索空间
- 解决欠拟合与过拟合的问题。

详细请参考之前的文章：[线性回归--第5点](https://github.com/NLP-LOVE/ML-NLP/tree/master/Machine%20Learning/Liner%20Regression)

### 2.4 常见的几种最优化方法

1. **梯度下降法**

   梯度下降法是最早最简单，也是最为常用的最优化方法。梯度下降法实现简单，当目标函数是凸函数时，梯度下降法的解是全局解。一般情况下，其解不保证是全局最优解，梯度下降法的速度也未必是最快的。梯度下降法的优化思想是用当前位置负梯度方向作为搜索方向，因为该方向为当前位置的最快下降方向，所以也被称为是”最速下降法“。最速下降法越接近目标值，步长越小，前进越慢。梯度下降法的搜索迭代示意图如下图所示：

   ![](https://images2017.cnblogs.com/blog/1022856/201709/1022856-20170916201932735-243646199.png)

   缺点：靠近极小值时收敛速度减慢；直线搜索时可能会产生一些问题；可能会“之字形”地下降。

2. **牛顿法**

   牛顿法是一种在实数域和复数域上近似求解方程的方法。方法使用函数f (x)的泰勒级数的前面几项来寻找方程f (x) = 0的根。牛顿法最大的特点就在于它的收敛速度很快。具体步骤：

   - 首先，选择一个接近函数 f (x)零点的 x0，计算相应的 f (x0) 和切线斜率f  ' (x0)（这里f ' 表示函数 f  的导数）。

   - 然后我们计算穿过点(x0,  f  (x0)) 并且斜率为f '(x0)的直线和 x 轴的交点的x坐标，也就是求如下方程的解：

     ![](https://latex.codecogs.com/gif.latex?x*f^{'}(x_0)+f(x_0)-x_0*f^{'}(x_0)=0)

   - 我们将新求得的点的 x 坐标命名为x1，通常x1会比x0更接近方程f  (x) = 0的解。因此我们现在可以利用x1开始下一轮迭代。

   由于牛顿法是基于当前位置的切线来确定下一次的位置，所以牛顿法又被很形象地称为是"切线法"。牛顿法搜索动态示例图：

   ![](https://images2017.cnblogs.com/blog/1022856/201709/1022856-20170916202719078-1588446775.gif)

   从本质上去看，牛顿法是二阶收敛，梯度下降是一阶收敛，所以牛顿法就更快。**缺点：**

   - 牛顿法是一种迭代算法，每一步都需要求解目标函数的Hessian矩阵的逆矩阵，计算比较复杂。
   - 在高维情况下这个矩阵非常大，计算和存储都是问题。
   - 在小批量的情况下，牛顿法对于二阶导数的估计噪声太大。
   - 目标函数非凸的时候，牛顿法容易受到鞍点或者最大值点的吸引。

3. **拟牛顿法**

   拟牛顿法是求解非线性优化问题最有效的方法之一，**本质思想是改善牛顿法每次需要求解复杂的Hessian矩阵的逆矩阵的缺陷，它使用正定矩阵来近似Hessian矩阵的逆，从而简化了运算的复杂度。**拟牛顿法和梯度下降法一样只要求每一步迭代时知道目标函数的梯度。通过测量梯度的变化，构造一个目标函数的模型使之足以产生超线性收敛性。这类方法大大优于梯度下降法，尤其对于困难的问题。另外，因为拟牛顿法不需要二阶导数的信息，所以有时比牛顿法更为有效。如今，优化软件中包含了大量的拟牛顿算法用来解决无约束，约束，和大规模的优化问题。

4. **共轭梯度法**

   共轭梯度法是介于梯度下降法与牛顿法之间的一个方法，它仅需利用一阶导数信息，但克服了梯度下降法收敛慢的缺点，又避免了牛顿法需要存储和计算Hesse矩阵并求逆的缺点，共轭梯度法不仅是解决大型线性方程组最有用的方法之一，也是解大型非线性最优化最有效的算法之一。 在各种优化算法中，共轭梯度法是非常重要的一种。其优点是所需存储量小，具有步收敛性，稳定性高，而且不需要任何外来参数。

   具体的实现步骤请参加wiki百科[共轭梯度法](https://en.wikipedia.org/wiki/Conjugate_gradient_method#Example_code_in_MATLAB)。下图为共轭梯度法和梯度下降法搜索最优解的路径对比示意图：

   ![](http://wx2.sinaimg.cn/mw690/00630Defly1g5ch0r2p48j308z0almy4.jpg)

### 2.5 降维方法

#### 2.5.1 线性判别分析（LDA）

线性判别分析（Linear Discriminant Analysis，LDA）是一种经典的降维方法。和主成分分析PCA不考虑样本类别输出的无监督降维技术不同，LDA是一种监督学习的降维技术，数据集的每个样本有类别输出。  

LDA分类思想简单总结如下：  

1. 多维空间中，数据处理分类问题较为复杂，LDA算法将多维空间中的数据投影到一条直线上，将d维数据转化成1维数据进行处理。  
2. 对于训练数据，设法将多维数据投影到一条直线上，同类数据的投影点尽可能接近，异类数据点尽可能远离。  
3. 对数据进行分类时，将其投影到同样的这条直线上，再根据投影点的位置来确定样本的类别。  

如果用一句话概括LDA思想，**即“投影后类内方差最小，类间方差最大”。**

假设有红、蓝两类数据，这些数据特征均为二维，如下图所示。我们的目标是将这些数据投影到一维，让每一类相近的数据的投影点尽可能接近，不同类别数据尽可能远，即图中红色和蓝色数据中心之间的距离尽可能大。

![](http://wx4.sinaimg.cn/mw690/00630Defgy1g5ma79ujplj30qr0ac3z8.jpg)

左图和右图是两种不同的投影方式。

​	左图思路：让不同类别的平均点距离最远的投影方式。

​	右图思路：让同类别的数据挨得最近的投影方式。

​	从上图直观看出，右图红色数据和蓝色数据在各自的区域来说相对集中，根据数据分布直方图也可看出，所以右图的投影效果好于左图，左图中间直方图部分有明显交集。

​	以上例子是基于数据是二维的，分类后的投影是一条直线。如果原始数据是多维的，则投影后的分类面是一低维的超平面。

**优缺点**

| 优缺点 | 简要说明                                                     |
| :----: | :----------------------------------------------------------- |
|  优点  | 1. 可以使用类别的先验知识；<br />2. 以标签、类别衡量差异性的有监督降维方式，相对于PCA的模糊性，其目的更明确，更能反映样本间的差异； |
|  缺点  | 1. LDA不适合对非高斯分布样本进行降维；<br />2. LDA降维最多降到分类数k-1维；<br />3. LDA在样本分类信息依赖方差而不是均值时，降维效果不好；<br />4. LDA可能过度拟合数据。 |

#### 2.5.2 主成分分析（PCA）

1. PCA就是将高维的数据通过线性变换投影到低维空间上去。
2. 投影思想：找出最能够代表原始数据的投影方法。被PCA降掉的那些维度只能是那些噪声或是冗余的数据。
3. 去冗余：去除可以被其他向量代表的线性相关向量，这部分信息量是多余的。
4. 去噪声，去除较小特征值对应的特征向量，特征值的大小反映了变换后在特征向量方向上变换的幅度，幅度越大，说明这个方向上的元素差异也越大，要保留。
5. 对角化矩阵，寻找极大线性无关组，保留较大的特征值，去除较小特征值，组成一个投影矩阵，对原始样本矩阵进行投影，得到降维后的新样本矩阵。
6. 完成PCA的关键是——协方差矩阵。协方差矩阵，能同时表现不同维度间的相关性以及各个维度上的方差。协方差矩阵度量的是维度与维度之间的关系，而非样本与样本之间。
7. 之所以对角化，因为对角化之后非对角上的元素都是0，达到去噪声的目的。对角化后的协方差矩阵，对角线上较小的新方差对应的就是那些该去掉的维度。所以我们只取那些含有较大能量(特征值)的维度，其余的就舍掉，即去冗余。

**图解PCA**

PCA可解决训练数据中存在数据特征过多或特征累赘的问题。核心思想是将m维特征映射到n维（n < m），这n维形成主元，是重构出来最能代表原始数据的正交特征。

​	假设数据集是m个n维，$(\boldsymbol x^{(1)}, \boldsymbol x^{(2)}, \cdots, \boldsymbol x^{(m)})$。如果$n=2$，需要降维到$n'=1$，现在想找到某一维度方向代表这两个维度的数据。下图有$u_1, u_2$两个向量方向，但是哪个向量才是我们所想要的，可以更好代表原始数据集的呢？

![](F:/jianguo_syc/GitHub/DeepLearning-500-questions-master/ch02_%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E5%9F%BA%E7%A1%80/img/ch2/2.34/1.png)

从图可看出，$u_1$比$u_2$好，为什么呢？有以下两个主要评价指标：

1. 样本点到这个直线的距离足够近。
2. 样本点在这个直线上的投影能尽可能的分开。

如果我们需要降维的目标维数是其他任意维，则：

1. 样本点到这个超平面的距离足够近。
2. 样本点在这个超平面上的投影能尽可能的分开。

**优缺点**

| 优缺点 | 简要说明                                                     |
| :----: | :----------------------------------------------------------- |
|  优点  | 1. 仅仅需要以方差衡量信息量，不受数据集以外的因素影响。　2.各主成分之间正交，可消除原始数据成分间的相互影响的因素。3. 计算方法简单，主要运算是特征值分解，易于实现。 |
|  缺点  | 1.主成分各个特征维度的含义具有一定的模糊性，不如原始样本特征的解释性强。2. 方差小的非主成分也可能含有对样本差异的重要信息，因降维丢弃可能对后续数据处理有影响。 |

#### 2.5.3 比较这两种方法

**降维的必要性**：

1. 多重共线性和预测变量之间相互关联。多重共线性会导致解空间的不稳定，从而可能导致结果的不连贯。
2. 高维空间本身具有稀疏性。一维正态分布有68%的值落于正负标准差之间，而在十维空间上只有2%。
3. 过多的变量，对查找规律造成冗余麻烦。
4. 仅在变量层面上分析可能会忽略变量之间的潜在联系。例如几个预测变量可能落入仅反映数据某一方面特征的一个组内。

**降维的目的**：

1. 减少预测变量的个数。
2. 确保这些变量是相互独立的。
3. 提供一个框架来解释结果。相关特征，特别是重要特征更能在数据中明确的显示出来；如果只有两维或者三维的话，更便于可视化展示。
4. 数据在低维下更容易处理、更容易使用。
5. 去除数据噪声。
6. 降低算法运算开销。

**LDA和PCA区别**

| 异同点 | LDA                                                          | PCA                                |
| :----: | :----------------------------------------------------------- | :--------------------------------- |
| 相同点 | 1. 两者均可以对数据进行降维；<br />2. 两者在降维时均使用了矩阵特征分解的思想；<br />3. 两者都假设数据符合高斯分布； |                                    |
| 不同点 | 有监督的降维方法；                                           | 无监督的降维方法；                 |
|        | 降维最多降到k-1维；                                          | 降维多少没有限制；                 |
|        | 可以用于降维，还可以用于分类；                               | 只用于降维；                       |
|        | 选择分类性能最好的投影方向；                                 | 选择样本点投影具有最大方差的方向； |
|        | 更明确，更能反映样本间差异；                                 | 目的较为模糊；                     |   

## 3. 机器学习评估方法

混淆矩阵也称误差矩阵，是表示精度评价的一种标准格式，用n行n列的矩阵形式来表示。具体评价指标有总体精度、制图精度、用户精度等，这些精度指标从不同的侧面反映了图像分类的精度。下图为混淆矩阵

|          | 正类                | 负类                |
| -------- | ------------------- | ------------------- |
| 预测正确 | TP(True Positives)  | FP(False Positives) |
| 预测错误 | FN(False Negatives) | TN(True Negatives)  |

### 3.1 准确率(Accuracy)

**准确率（Accuracy）。**顾名思义，就是所有的预测正确（正类负类）的占总的比重。

![](https://latex.codecogs.com/gif.latex?Accuracy=\frac{TP+TN}{TP+TN+FP+FN})

准确率是分类问题中最简单也是最直观的评价指标，但存在明显的缺陷。比 如，当负样本占99%时，分类器把所有样本都预测为负样本也可以获得99%的准确 率。所以，当不同类别的样本比例非常不均衡时，占比大的类别往往成为影响准 确率的最主要因素。

### 3.2 精确率（Precision）

**精确率（Precision）**，查准率。即正确预测为正的占全部预测为正的比例。个人理解：真正正确的占所有预测为正的比例。

![](https://latex.codecogs.com/gif.latex?Precision=\frac{TP}{TP+FP})

### 3.3 召回率(Recall)

**召回率（Recall）**，查全率。即正确预测为正的占全部实际为正的比例。个人理解：真正正确的占所有实际为正的比例。

![](https://latex.codecogs.com/gif.latex?Recall=\frac{TP}{TP+FN})

为了综合评估一个排序模型的好坏，不仅要看模型在不同 Top N下的Precision@N和Recall@N，而且最好绘制出模型的P-R（Precision- Recall）曲线。这里简单介绍一下P-R曲线的绘制方法。

P-R曲线的横轴是召回率，纵轴是精确率。对于一个排序模型来说，其P-R曲 线上的一个点代表着，在某一阈值下，模型将大于该阈值的结果判定为正样本， 小于该阈值的结果判定为负样本，此时返回结果对应的召回率和精确率。整条P-R 曲线是通过将阈值从高到低移动而生成的。下图是P-R曲线样例图，其中实线代表 模型A的P-R曲线，虚线代表模型B的P-R曲线。原点附近代表当阈值最大时模型的 精确率和召回率。

![](http://wx2.sinaimg.cn/mw690/00630Defly1g5e4ocvl8aj30ep0d275m.jpg)

由图可见，当召回率接近于0时，模型A的精确率为0.9，模型B的精确率是1， 这说明模型B得分前几位的样本全部是真正的正样本，而模型A即使得分最高的几 个样本也存在预测错误的情况。并且，随着召回率的增加，精确率整体呈下降趋 势。但是，当召回率为1时，模型A的精确率反而超过了模型B。**这充分说明，只用某个点对应的精确率和召回率是不能全面地衡量模型的性能，只有通过P-R曲线的 整体表现，才能够对模型进行更为全面的评估。**

### 3.4 F1值(H-mean值)

F1值（H-mean值）。F1值为算数平均数除以几何平均数，且越大越好，将Precision和Recall的上述公式带入会发现，当F1值小时，True Positive相对增加，而false相对减少，即Precision和Recall都相对增加，即F1对Precision和Recall都进行了加权。

![](https://latex.codecogs.com/gif.latex?\frac{2}{F_1}=\frac{1}{Precision}+\frac{1}{Recall})

![](https://latex.codecogs.com/gif.latex?F_1=\frac{2PR}{P+R}=\frac{2TP}{2TP+FP+FN})

### 3.4 ROC曲线

ROC曲线。接收者操作特征曲线（receiver operating characteristic curve），是反映敏感性和特异性连续变量的综合指标，ROC曲线上每个点反映着对同一信号刺激的感受性。下图是ROC曲线例子。

![](http://wx2.sinaimg.cn/mw690/00630Defly1g5e4fnjx1dj308w08waby.jpg)

横坐标：1-Specificity，伪正类率(False positive rate，FPR，FPR=FP/(FP+TN))，预测为正但实际为负的样本占所有负例样本的比例；

纵坐标：Sensitivity，真正类率(True positive rate，TPR，TPR=TP/(TP+FN))，预测为正且实际为正的样本占所有正例样本的比例。

**真正的理想情况**，TPR应接近1，FPR接近0，即图中的（0,1）点。**ROC曲线越靠拢（0,1）点，越偏离45度对角线越好**。

**AUC值**

AUC (Area Under Curve) 被定义为ROC曲线下的面积，显然这个面积的数值不会大于1。又由于ROC曲线一般都处于y=x这条直线的上方，所以AUC的取值范围一般在0.5和1之间。使用AUC值作为评价标准是因为很多时候ROC曲线并不能清晰的说明哪个分类器的效果更好，而作为一个数值，对应AUC更大的分类器效果更好。

从AUC判断分类器（预测模型）优劣的标准：

- AUC = 1，是完美分类器，采用这个预测模型时，存在至少一个阈值能得出完美预测。绝大多数预测的场合，不存在完美分类器。
- 0.5 < AUC < 1，优于随机猜测。这个分类器（模型）妥善设定阈值的话，能有预测价值。
- AUC = 0.5，跟随机猜测一样（例：丢铜板），模型没有预测价值。
- AUC < 0.5，比随机猜测还差；但只要总是反预测而行，就优于随机猜测。

**一句话来说，AUC值越大的分类器，正确率越高。**

### 3.5 余弦距离和欧式距离

**余弦距离：** ![](https://latex.codecogs.com/gif.latex?cos(A,B)=\frac{A*B}{||A||_2||B||_2})

**欧式距离：**在数学中，欧几里得距离或欧几里得度量是欧几里得空间中两点间“普通”（即直线）距离。

对于两个向量A和B，余弦距离关注的是向量之间的角度关系，并不关心它们的绝对大小，其取值 范围是[−1,1]。当一对文本相似度的长度差距很大、但内容相近时，如果使用词频 或词向量作为特征，它们在特征空间中的的欧氏距离通常很大；而如果使用余弦 相似度的话，它们之间的夹角可能很小，因而相似度高。此外，在文本、图像、 视频等领域，研究的对象的特征维度往往很高，余弦相似度在高维情况下依然保 持“相同时为1，正交时为0，相反时为−1”的性质，而欧氏距离的数值则受维度的 影响，范围不固定，并且含义也比较模糊。

### 3.6 A/B测试

AB测试是为Web或App界面或流程制作两个（A/B）或多个（A/B/n）版本，在同一时间维度，分别让组成成分相同（相似）的访客群组（目标人群）随机的访问这些版本，收集各群组的用户体验数据和业务数据，最后分析、评估出最好版本，正式采用。

### 3.7 模型评估方法

1. **Holdout检验**

   Holdout 检验是最简单也是最直接的验证方法，它将原始的样本集合随机划分 成训练集和验证集两部分。比方说，对于一个点击率预测模型，我们把样本按照 70%～30% 的比例分成两部分，70% 的样本用于模型训练；30% 的样本用于模型 验证，包括绘制ROC曲线、计算精确率和召回率等指标来评估模型性能。

   Holdout 检验的缺点很明显，即在验证集上计算出来的最后评估指标与原始分 组有很大关系。为了消除随机性，研究者们引入了“交叉检验”的思想。

2. **交叉检验**

   k-fold交叉验证：首先将全部样本划分成k个大小相等的样本子集；依次遍历 这k个子集，每次把当前子集作为验证集，其余所有子集作为训练集，进行模型的 训练和评估；最后把k次评估指标的平均值作为最终的评估指标。在实际实验 中，k经常取10。

3. **自助法**

   不管是Holdout检验还是交叉检验，都是基于划分训练集和测试集的方法进行 模型评估的。然而，当样本规模比较小时，将样本集进行划分会让训练集进一步 减小，这可能会影响模型训练效果。有没有能维持训练集样本规模的验证方法 呢？自助法可以比较好地解决这个问题。 

   自助法是基于自助采样法的检验方法。对于总数为n的样本集合，进行n次有 放回的随机抽样，得到大小为n的训练集。n次采样过程中，有的样本会被重复采 样，有的样本没有被抽出过，将这些没有被抽出的样本作为验证集，进行模型验 证，这就是自助法的验证过程。

### 3.8 超参数调优

为了进行超参数调优，我们一般会采用网格搜索、随机搜索、贝叶斯优化等 算法。在具体介绍算法之前，需要明确超参数搜索算法一般包括哪几个要素。一 是目标函数，即算法需要最大化/最小化的目标；二是搜索范围，一般通过上限和 下限来确定；三是算法的其他参数，如搜索步长。

- **网格搜索**，可能是最简单、应用最广泛的超参数搜索算法，它通过查找搜索范 围内的所有的点来确定最优值。如果采用较大的搜索范围以及较小的步长，网格 搜索有很大概率找到全局最优值。然而，**这种搜索方案十分消耗计算资源和时间**，特别是需要调优的超参数比较多的时候。因此，在实际应用中，网格搜索法一般会先使用较广的搜索范围和较大的步长，来寻找全局最优值可能的位置；然 后会逐渐缩小搜索范围和步长，来寻找更精确的最优值。这种操作方案可以降低 所需的时间和计算量，但由于目标函数一般是非凸的，所以很可能会错过全局最 优值。
- **随机搜索**，随机搜索的思想与网格搜索比较相似，只是不再测试上界和下界之间的所有 值，而是在搜索范围中随机选取样本点。它的理论依据是，如果样本点集足够 大，那么通过随机采样也能大概率地找到全局最优值，或其近似值。随机搜索一 般会比网格搜索要快一些，但是和网格搜索的快速版一样，它的结果也是没法保证的。
- **贝叶斯优化算法**，贝叶斯优化算法在寻找最优最值参数时，采用了与网格搜索、随机搜索完全 不同的方法。网格搜索和随机搜索在测试一个新点时，会忽略前一个点的信息； 而贝叶斯优化算法则充分利用了之前的信息。贝叶斯优化算法通过对目标函数形 状进行学习，找到使目标函数向全局最优值提升的参数。

### 3.9 过拟合和欠拟合

过拟合是指模型对于训练数据拟合呈过当的情况，反映到评估指标上，就是 模型在训练集上的表现很好，但在测试集和新数据上的表现较差。欠拟合指的是 模型在训练和预测时表现都不好的情况。下图形象地描述了过拟合和欠拟合的区别。

![](http://wx1.sinaimg.cn/mw690/00630Defly1g5e5937nuej30hw05i3zl.jpg)

1. **防止过拟合：**
   - 从数据入手，获得更多的训练数据。
   - 降低模型复杂度。
   - 正则化方法，给模型的参数加上一定的正则约束。
   - 集成学习方法，集成学习是把多个模型集成在一起。
2. **防止欠拟合：**
   - 添加新特征。
   - 增加模型复杂度。
   - 减小正则化系数。

## 4. 检验方法

### 4.1 KS检验

Kolmogorov-Smirnov检验是基于累计分布函数的，用于检验一个分布是否符合某种理论分布或比较两个经验分布是否有显著差异。

- 单样本K-S检验是用来检验一个数据的观测经验分布是否符合已知的理论分布。
- 两样本K-S检验由于对两样本的经验分布函数的位置和形状参数的差异都敏感，所以成为比较两样本的最有用且最常用的非参数方法之一。

检验统计量为：![](https://latex.codecogs.com/gif.latex?D_r=max_x|F_n(x)-F(x)|)

其中  ![](https://latex.codecogs.com/gif.latex?F_n(x))为观察序列值，![](https://latex.codecogs.com/gif.latex?F(x))为理论序列值或另一观察序列值。

### 4.2 T检验

T检验，也称student t检验，主要用户样本含量较小，总体标准差未知的正态分布。

t检验是用t分布理论来推论差异发生的概率，从而比较两个平均数的差异是否显著。

t检验分为单总体检验和双总体检验。

### 4.3 F检验

T检验和F检验的由来：为了确定从样本中的统计结果推论到总体时所犯错的概率。F检验又叫做联合假设检验，也称方差比率检验、方差齐性检验。是由英国统计学家Fisher提出。通过比较两组数据的方差，以确定他们的精密度是否有显著性差异。

### 4.4 Grubbs检验

一组测量数据中，如果个别数据偏离平均值很远，那么称这个数据为“可疑值”。用格拉布斯法判断，能将“可疑值”从测量数据中剔除。

### 4.5 卡方检验

卡方检验就是统计样本的实际观测值与理论推断值之间的偏离程度，实际观测值与理论推断值之间的偏离程度就决定卡方值的大小，卡方值越大，越不符合；卡方值越小，偏差越小，越趋于符合，若两个值完全相等时，卡方值就为0，表明理论值完全符合。

1. 提出原假设H0：总体X的分布函数F(x)；

2. 将总体x的取值范围分成k个互不相交的小区间A1-Ak；

3. 把落入第i个区间Ai的样本的个数记做fi，成为组频数，f1+f2+f3+...+fk = n；

4. 当H0为真时，根据假设的总体理论分布，可算出总体X的值落入第i个小区间Ai的概率pi，于是n*pi就是落入第i个小区间Ai的样本值的理论频数；

5. 当H0为真时，n次试验中样本落入第i个小区间Ai的频率fi/n与概率pi应该很接近。基于这种思想，皮尔逊引入检测统计量：

   ![](https://latex.codecogs.com/gif.latex?x^2=\sum_{i=1}^{k}\frac{(f_i-np_i)^2}{np_i})

   在H0假设成立的情况下服从自由度为k-1的卡方分布。

**KS检验与卡方检验**

**相同点：**都采用实际频数和期望频数只差进行检验

**不同点：**

- 卡方检验主要用于类别数据，而KS检验主要用于有计量单位的连续和定量数据。
- 卡方检验也可以用于定量数据，但必须先将数据分组才能获得实际的观测频数，而KS检验能直接对原始数据进行检验，所以它对数据的利用比较完整。

## 5. 参考文献

[百面机器学习](https://www.lanzous.com/i56i24f)

> 作者：[@mantchs](https://github.com/NLP-LOVE/ML-NLP)
>
> GitHub：[https://github.com/NLP-LOVE/ML-NLP](https://github.com/NLP-LOVE/ML-NLP)
>
> 欢迎大家加入讨论！共同完善此项目！群号：【541954936】<a target="_blank" href="//shang.qq.com/wpa/qunwpa?idkey=863f915b9178560bd32ca07cd090a7d9e6f5f90fcff5667489697b1621cecdb3"><img border="0" src="http://pub.idqqimg.com/wpa/images/group.png" alt="NLP面试学习群" title="NLP面试学习群"></a>
